
sigma = 2 ; % risk aversion ; IES is 1/sigma
beta = .995 ; % discount factor (period = quarter)
lambda = .25/16 ; %.25/16 ; % loss function - weight on output stabilization
kappa = .025 ; % *4 ; % .02*4 ; %04 ; .10 ; % 1*4 ; % slope of Phillips curve (coeff 4 to annualize)
pistar = .02/4 ; % inflation target

% process for exogenous variables
ac_eps = 0.85 ; % persistence of natural rate shock
ac_u = 0 ; % persistence of cost-push shock
std_uX =  0.001 ; % unconditional standard deviation of cost-push variable
std_epsX = 0.025/4 ; % unconditional standard deviation of natural rate \
rho0 = -0.005/4 ; % initial value of rho_n at time 0 (divide by 4 to annualize)
rho_end = 0.0175/4 ; % final rho_n
T2 = 24 ; % number of periods of (linear) rise in the natural real rate
T = 26 ; % number of periods simulated; for t>=T, it is assumed there is NO uncertainty
T3 = 24 ; %  for t>=T3, the volatility is reduced by scaleXX (roughly, so there is no risk of ZLB)
truncatet = 1   ; % set to 1 to make T3 active

% by which factor to reduce vol so that zlb does not bind?
% i.e. want: min(rn) + sigma*kappa*(kappa^2+lambda)*min(u)>0
% [~, grid_epsclarify] = rouwen(ac_eps, 0, 1, Ne);
% [~, grid_uclarify] = rouwen(ac_u, 0, 1, Nu);
% i.e.
% scaleXX =  (rho_end + pistar )/(max(grid_epsclarify)*std_epsX + sigma*kappa/(lambda+kappa^2)*(max(grid_uclarify)*std_uX)) ;
% more simply, kill off all variance for t>=T3!
scaleXX = 0 ;

% rules for alternative policies
phiA = 0 ; gammaA = 0 ; % just set i = rho_n
gammaB = 0 ; % weight on output gap (need to divide by 4 to annualize)
gammaC = .5/4 ; % weight on output gap (need to divide by 4 to annualize)
phiB = 2 ; % weight on inflation
phiC = 1.5 ; % weight on inflation
rho_hat = rho_end ; % intercept in taylor rule for natural real rate (if equal to rho_end this means TR has the correct LR rate)

% computational parameters
thresholdzlb = .25 ; % for sims: threshold to define liftoff in simulations (no need to annualize)
Ts = 24 ; % for plots
T11 = 25 ;% number of periods over which the stats are calculated (e.g. p75 max pi, etc.)
Nsimul = 5e4 ; % number of simulations
printyes = 0 ; % set to 1 to print an eps of figures
n_eps = 9 ; % number of shock values (natural rate) - set a bit lower to economize on time
n_u = 5 ; % number of shock values (cost-push shock) - set a bit lower to economize on time

ZLBI = - pistar ; % effective ZLB since we solve the model in deviation from steady-state


